﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace YumeNikkiRandomizer
{
    class CommonEvents : RPGByteData
    {
        List<CommonEvent> commonEvents;
        
        public CommonEvents(FileStream f)
        {
            load(f);
        }
        public CommonEvents()
        {
        }
        
        override public void load(FileStream f)
        {
            commonEvents = M.readDatabaseList<CommonEvent>(f, "Common Events", "Common", ref M.commonNames);
        }
        
        // Applies the validated random layout.
        public void applyLayout()
        {
            foreach (CommonEvent commonEvent in commonEvents)
                commonEvent.applyLayout();
        }
        
        // Checks for teleport commands in all events.
        public void getWarps()
        {
            for (int i = 0; i < commonEvents.Count; i++)
            {
                M.currentEvent = "Common " + (i + 1);
                M.currentEventNum = i + 1;
                M.currentPage = "";
                M.currentPageNum = 0;
                
                commonEvents[i].getWarps();
            }
        }
        
        override protected void myWrite()
        {
            M.writeListNoLength<CommonEvent>(commonEvents);
        }
    }
    
    class CommonEvent : RPGDatabaseEntry
    {
        int id = 0;
        string commonName = ""; // 01
        int eventTrigger = 5; // 0b
        bool usingSwitch = false; // 0c
        int switchNum = 1; // 0d
        List<Command> commands; // 15 length, 16 content
        
        static string myClass = "CommonEvent";
        Chunks chunks;
        
        bool clearedManagers = false;
        
        public CommonEvent(FileStream f)
        {
            load(f);
        }
        public CommonEvent()
        {
        }
        
        public void load(FileStream f)
        {
            chunks = new Chunks(f, myClass);
            
            id = M.readMultibyte(f);
            
            if (chunks.next(0x01))
                commonName = M.readStringDataName(f, id, ref M.commonNames, M.S_UNTRANSLATED);
            
            if (chunks.next(0x0b))
                eventTrigger = M.readLengthMultibyte(f);
            if (chunks.next(0x0c))
                usingSwitch = M.readLengthBool(f);
            if (chunks.next(0x0d))
                switchNum = M.readLengthMultibyte(f);
            
            if (chunks.next(0x15))
                M.readLengthMultibyte(f); // Commands section length
            
            if (chunks.next(0x16))
                commands = M.readCommandList(f);
            
            M.byteCheck(f, 0x00);
        }
        
        // Applies the validated random layout.
        public void applyLayout()
        {
            // Edit warps.
            foreach (string key in M.warpLocations.Keys)
            {
                if (M.warpLocations[key] is CommonLocation)
                {
                    CommonLocation location = M.warpLocations[key] as CommonLocation;
                    if (location.eventID == id)
                        editWarp(location, M.exits[key]);
                }
                else if (M.warpLocations[key] is CombinedLocation)
                {
                    if (M.warpLocations[key] is CommonLocation)
                    {
                        CombinedLocation combo = M.warpLocations[key] as CombinedLocation;
                        foreach (CommonLocation location in combo.locations)
                        {
                            if (location.eventID == id)
                                editWarp(location, M.exits[key]);
                        }
                    }
                }
            }
            
            // Miscellaneous changes.
            if (M.darknessLevel != 0)
            {
                if (id == 92 || id == 238) // Fixed Screen Tone, [Pre]Entering Dark
                {
                    int value = M.darknessLevel == 1? 50 : 25;
                    editScreenTone(value, value, value, 100);
                }
            }
        }
        
        // Edits warp commands to go somewhere different.
        void editWarp(CommonLocation location, Warp warp)
        {
            if (!clearedManagers)
            {
                removeWarpManagers();
                clearedManagers = true;
            }
            
            editTeleport(warp, location.commandNum);
            
            List<int> commonsBeforeTeleport = new List<int>();
            List<int> commonsAfterTeleport = new List<int>();
            Map.determineWarpManagers(ref commonsBeforeTeleport, ref commonsAfterTeleport, location, warp);
            
            foreach (int commonID in commonsBeforeTeleport)
                addCommonNearTeleport(location, commonID, 0);
            foreach (int commonID in commonsAfterTeleport)
                addCommonNearTeleport(location, commonID, 1);
        }
        
        // Edits warp in Xth teleport command.
        void editTeleport(Warp newWarp, int num = 1)
        {
            Command command = getCommand(num, Command.C_TELEPORT);
            command.args[0] = newWarp.mapID;
            command.args[1] = newWarp.x;
            command.args[2] = newWarp.y;
            command.args[3] = newWarp.dir + 1;
        }
        
        // Edits tint color in Xth screen tone command.
        void editScreenTone(int red, int green, int blue, int chroma, int num = 1)
        {
            Command command = getCommand(num, Command.C_SCREENTONE);
            command.args[0] = red;
            command.args[1] = green;
            command.args[2] = blue;
            command.args[3] = chroma;
        }
        
        // Removes common calls related to warps, to be replaced by the appropriate ones for the new warp.
        void removeWarpManagers()
        {
            List<Command> toRemove = new List<Command>();
            for (int i = 0; i < commands.Count; i++)
            {
                Command command = commands[i];
                if (command.opcode == Command.C_CALLEVENT && command.args[0] == 0)
                {
                    int commonID = command.args[1];
                    if ((commonID >= 234 && commonID <= 299) // New management commons
                      || commonID == 138 || commonID == 139) // Original FC World entrance/exit commons
                        toRemove.Add(command);
                }
            }
            
            foreach (Command command in toRemove)
                commands.Remove(command);
        }
        
        // Generic function for adding a common call either before or after a teleport command.
        void addCommonNearTeleport(CommonLocation location, int commonID, int offset)
        {
            int commandNum = 0;
            
            for (int i = 0; i < commands.Count; i++)
            {
                Command command = commands[i];
                if (command.opcode == Command.C_TELEPORT)
                {
                    commandNum++;
                    if (commandNum == location.commandNum)
                    {
                        commands.Insert(i + offset, new Command(Command.C_CALLEVENT, command.indent, new int[] { 0, commonID, 0 }));
                        break;
                    }
                }
            }
        }
        
        // Checks commands for teleports.
        public void getWarps()
        {
            for (int i = 0; i < commands.Count; i++)
            {
                M.currentLine = "Line " + (i + 1);
                commands[i].getWarps();
            }
        }
        
        public void write()
        {
            M.writeMultibyte(id);
            
            if (chunks.wasNext(0x01))
                M.writeString(commonName, M.S_UNTRANSLATED);
            
            if (chunks.wasNext(0x0b))
                M.writeLengthMultibyte(eventTrigger);
            if (chunks.wasNext(0x0c))
                M.writeLengthBool(usingSwitch);
            if (chunks.wasNext(0x0d))
                M.writeLengthMultibyte(switchNum);
            
            if (chunks.wasNext(0x15))
                M.writeLengthMultibyte(getCommandsLength());
            
            if (chunks.wasNext(0x16))
                M.writeCommandList(commands);
           
            M.writeByte(0x00);
        }
        
        public int getCommandsLength()
        {
            int length = 0;
            foreach (Command command in commands)
                length += command.getLength();
            return length;
        }
        
        public bool isBlank()
        {
            if (commonName != "" // 01
             || eventTrigger != 5 // 0b
             || usingSwitch // 0c
             // 0d irrelevant (usingSwitch is all that matters)
             || commands.Count > 1) // 15; the end command counts!
                return false;
            
            return true;
        }
        
        // Returns Xth command in common event.
        public Command getCommand(int num, int opcode)
        {
            int commandNum = 0;
            
            for (int i = 0; i < commands.Count; i++)
            {
                Command command = commands[i];
                if (command.opcode == opcode)
                {
                    commandNum++;
                    if (commandNum == num)
                        return command;
                }
            }
            
            Console.WriteLine("Warning: Command to edit not found!");
            return null;
        }
    }
}
